*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Phorate oxon sulfone                                 *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";

libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";
/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/

data phorateoxonsulfone;
     set epa.phorateoxonsulfone;
run;
proc sort data=phorateoxonsulfone;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfone - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Phorateoxonsulfone);
ods rtf close;



*==> Human vs. rat;

title "Human vs. rat: final model 3";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=PhorateOxonSulfone  method=firo tech=newrap lis=3 maxiter=1000;
      PARMS ha=1.2288
			hb=1.4582	
			ra=0.7374
			rb=0.7656	
			gha=0.3318	ghab=.1900		ghb=0.1393
			gra=0.1745	grab=0.2133	grb=.3083
			S2E=0.7083;

            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-5 + H_I__M + rrb*Rat*1e-5 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-4);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha, 
												 		 ghab, ghb,
														 0,    0,   gra,
														 0,    0,   grab, grb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfone human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=PhorateOxonSulfone, model=3)
ods rtf close;
%Calculate_Ki(chemical=PhorateOxonSulfone, Hadj=1e-5, Radj=1e-5);


*==> Adult vs. Infant;

title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=phorateoxonsulfone(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=1.2620	adB=0.1459
			ia=1.1090 iB=.1434
			gha=3.2064 	ghab=0.1947	ghb=0.01907
			S2E=0.06398;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-4 + H_I__M*adult + rib*1e-4*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-1]) SUBJECT=ID out=RandID_AI; 
	  ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfone Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=PhorateOxonSulfone, model=2)
ods rtf close;


*===> Male vs. female;


title "Final model 3 - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=phorateoxonsulfone(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=1.1653	mB=0.1444
			fa=1.2288 fB=0.1432
			gma=6.9363 	gmab=.495 	gmb=0.003463
			gfa=0.1004 	gfab=0.005101	gfb=0.01673
			S2E=.06284/ best=1000;
         	rma=ma+uma;
            rmb=mB+umb;
			rfa=fa+ufa;
			rfb=fB+ufb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-4 + H_I__M*male + rfb*female*1e-4 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);

      RANDOM  uma umb ufa ufb ~ normal([0, 0, 0, 0],   [gma*1e-1, 
														gmab*1e-1, gmb, 
														0,    0,     gfa, 
														0,    0,     gfab,   gfb*1e-1]) SUBJECT=ID out=RandID_MF; 

	  ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfone Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=PhorateOxonSulfone, model=3);
ods rtf close;


*===> Caucasian vs. Others;

title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=phorateoxonsulfone(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=1.0941	cB=1.3640
			ora=1.7991 orB=1.9408
			gha=3.1289	ghab=1.9646	ghb=0.1920
			S2E=.06427;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb]) SUBJECT=ID out=RandID_CO; 
	  ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfone Caucasian-Other.rtf" startpage=no;
%DiagnosticsCO(chemical=PhorateOxonSulfone, model=2);
ods rtf close;
